# Charity Notes 04: 塔木德时期的希腊罗马慈善概念

上节课主要讲了是圣经时期以色列和其他古代近东文化中的慈善概念及其对比，这节课主要讲塔木德时期以色列和希腊罗马世界的慈善概念的对比。希腊罗马称之为 euergetism，意为 “doing good deeds”。

这节课的材料有 Gardners 关于慈善的著作和 Van der Horst 的文章。我们将看到慈善的宗教动机和古典社会的荣誉和地位驱动的给予动机的区别。

==Euergetism== 的定义: 是根据希腊法令的措辞创造的，这些法令尊重恩人（euergetes）。 Euergetism是一种受益形式，<u>一位恩人给了一个城市的礼物，公民会通过给予恩人的礼物（return-gift）来回报</u>。

这种模式的非正式机构从公元前5世纪就在整个希腊语世纪广泛传播，在希腊化和罗马化时期的巴勒斯坦地区（Hellenistic and Roman-era Palestine）也有这样的情况。

一个恩人（benefactor）将资助公共工程，防御工事或其他形式的军事援助或市政服务，或资助当地的教会。作为回报，恩人将获得从标准化的奖励中抽取的礼物。礼物最具特色的 euergetism 是地方议会通过的一项荣誉法令，该法令叙述了恩人对城市的贡献，并赋予他或她个人荣誉。在法令中提出的荣誉伴随着给予恩人的其他礼物，包括他或她的形象中的雕像，冠和其他由金制成的物品，以及在游戏和节日中的荣誉座位。这些礼物是在赞扬恩人的公共仪式上颁发的，而且这些法令本身也刻在了显眼的地方。这有助于宣传其效果，鼓励他人为城市做出贡献，并提升恩人的社会地位。它创造了一个持久的纪念碑，只要带有铭文的石碑就会被记住。

因为这些恩赐<u>要么提升或巩固（elevated or solidified）恩人的社会地位，政治地位，或两者兼而有之</u>，否则提供了获得或维持权威的手段。和慈善事业不同，euergetism 旨在使**特定城镇的公民受益**。这些人可能包括有需要的人，但是他们的目标并不是针对“穷人”。虽然慈善在于道德领域，但是，euergetism 是==恩人获得荣誉和地位的机制==。

P. van der Host 的文章很好的让我们了解经典世界对穷人的态度。值得强调的是，尽管在罗马时代，免费面包被分发给人口。它仅限于<u>真正的公民</u>，任何不是公民的穷人都没有获得面包。此外，床的分配量也<u>不取决于需要喂食的需要量或口数</u>。每个户主都收到相同的金额。

之后 Gardners 的文章，“三世纪的竞争给予”，我们需要关注关于拉比在 Mishnah Yuma 和 Tosefta Peah 中的竞争性给予（ “competitive giving”）的方法。他的基本论点是，<u>犹太人对慈善事业的态度与经典世界的态度非常不同。拉比关心穷人，并期望犹太人慷慨地以免费礼物的方式支持他们，不要期待任何具体的回报，至少不是世俗的回报。</u>



## 慈善事业的希腊罗马观

（Graeco-Roman Views on Philanthropy）

Van der Horst 提到了 Bolkestein 的观点：穷人在希腊罗马文化中的地位和他们在古代以色列和早期犹太教的地位存在着根本区别。

- 当==希腊==文学提到给予他人的快乐时，这与利他主义无关，而与只与期望的给予效果相关，比如荣誉，声望，名望，地位。（honour, prestige, fame, status）**荣誉是大多数希腊人的理性背后的驱动力**，正是由于这个原因，希腊词 philotimia（对荣誉的爱，也作philodoxia）可以发展出“慷慨，善良“，但却不是针对穷人而是针对大众同胞的意义。

  所以，就像 **Hesiod** 简单地说明一样，”Give to him who gives, but do not give to him who does not give (in return)“ (Erga 354).

  宗教对穷人没有多大帮助，他们根本不是众神的最爱。<u>富人被视为神圣世界的最爱，他们的财富是这种恩惠的明显证明。“上帝爱穷人” 在古希腊将是一个奇怪的陈述。</u> 在背景下，人们普遍认为，穷人在道德上不如富人，他们往往被认为更容易做恶；因为这个原因，他们的贫困通常被认为是他们自己的错，被称为 ”selbstverschuldet“（意为self-inflicted，自我造成的）。在这样的社会中，**给穷人施舍不能被看作是一种美德。照顾穷人往往被视为浪费资源。**

- 当一个==罗马==人对其他人慷慨时，并不是因为这些人是穷人，而是因为他**希望获得回报**，因为**它赋予他荣誉和地位**。受益人是为了同胞而不是穷人，他们往往被视为道德低劣并倾向于犯罪。

  正如西塞罗（Cicero）说的那样，”most people are generous in their gifts not so much by natural inclination as by the lure of honour“（Off. 1.14.44）, 以及 Pliny the Younger pithily 说的，”honour must be the consequence“(sequi, gloria, debet)。

  除非是他们可以期待的政治支持，并且还可能导致获得荣誉，否则给穷人施舍是不值一文的。

  修昔底德（Thucydides）通过他创作的 Cleon 说：”怜悯是在交换的基础上适当地给予具有相似性格的人，而不是那些不会表示同情的人“。

在古希腊罗马古代，没有任何迹象表明任何私人捐助者歧视有利于下层阶级，也没有任何倾向将公共分配视为主要是为了帮助穷人而设立的公共分配。简而言之，**一视同仁**。<u>除非他们在政治上受到威胁，否则他们根本没有注意到穷人。</u>



从下一段开始是 Gardners 的文章。

## Euergetism，竞争和犹太理想

我们在开头已经解释了 Euergetism 这个词，我们知道他与社会地位息息相关。Euergetism是在希腊罗马城市获得或维持权威和影响力的手段。例如，国王是卓越的恩人。

Euergetism 的一个重要方面是==社会竞争==（social competition）：有两种竞争，

1. 一种是竞争城市（和他们各自的精英）之间，
2. 另一种是在一个地区内的个人之间。

后者将在城市的社会等级中建立一个人的本地身份和地位。但是竞争公共荣誉的角色给犹太人的理想带来了重大问题。犹太人没有看到财富和社会声望之间的直接联系（至少在理想情况下），因为犹太社会的**最高地位属于祭司**，他们的地位不是基于财富。同时euergetism保留了异教徒宗教信仰和奖励的一些元素，例如给予他/她形象的恩人雕像，这与禁止偶像崇拜的第二诫命发生冲突。



## 在早期拉比文学中的Euergetism 

早期的拉比文献中没有像菲洛（Philo）和约瑟夫斯(Josephus)那样的程序性或抽象的颂歌。然而，可以通过研究关于受益的关键文本来收集这些态度。其中两个特别突出与eourgetism的接触的例子：m. Yoma 的第三章，讨论对==耶路撒冷圣殿==的贡献；以及 t. Peah 4:18中关于==国王蒙巴兹（Munbaz）解除饥荒==的叙述。



### Yoma 3 的 Euergetism 

1. M. Yoma 3 中讨论了对圣殿的贡献。 Parvah chamber，它用以净化，**且以波斯恩人命名**。某些 Ben Gamla 捐赠的金币在赎罪日使用，取代黄桃木。作为回报，”他们一赞美的方式记住了他。“（m. Yoma 3:9）

2. 在m. Yoma 3:10中，Ben Qatin为 laver（洗濯盆）制作了十二个龙头，而之前只有两个。他们以赞美的方式记念了他。

这些做法<u>反映了希腊罗马形式</u>。但是值得注意的是，并没有直接的物质礼物汇报、促进社会竞争，在密西拿中只有通过赞美。



### Peah中消除 Euergetism

另一个对于 euergetism 的 Tannaitic 方法在 t. Peah 4:18：国王穆巴兹在多年的苦难中挥霍他的宝藏的故事。

在这一选段（pericope）中，国王穆巴兹[^1]通过向有需要的人赠送他的财宝来解除饥荒。他的兄弟们写信给他，将他的行为与保护祖先的家庭财产的行为形成鲜明对比，这让他感到震惊。 Munbaz反驳说，兄弟们误解了他的行为 - 他并没有浪费家庭财产，而是拯救并增加财产。他以六种方式将他的行为与他的祖先的行为区分和提升，每一种都有圣经证明文本的支持。

因此祖先在低矮的人类领域存储着有形和物质的宝藏，但是Munbaz将无形的宝藏储存在一个非物质的地方 - 在未来的世界之上，这是无法控制的。同样，利益/利润/果实和灵魂/生活的概念在世俗和超凡脱俗的背景下运作，出现在地上经济和法律问题的讨论以及关于惩罚，奖赏和神圣正义的论述中。

这些**礼物回馈来自神圣正义的拉比概念**，特别是对义人的奖赏。此外，这些超凡脱俗的奖赏与Munbaz所赐的地上利益相同。

t. Peah 4:18 在这些背景中==消除了 euergetism==。相对应的提供促进恩人的世俗地位的物质礼物回报，t. Peah 4:18 提供了<u>关于神圣正义的拉比话语所带来的无形和超凡脱俗的奖赏</u> - 这是一种特殊的拉比式的 euergetism 方法。此外，通过选择证据文本即，它是一种正义的形式，不仅鼓励了奖励，而且鼓励了这段经文的根本论证。



[^1]: 国王穆巴兹原型是一个公元一世纪巴比伦国王，他和他的家庭后来皈依了犹太教。



## Euergetism和犹太教

虽然典型的热情习俗是为了促进捐赠者的个人慷慨，但犹太教会的铭文将贡献作为履行宗教义务或作为奉献祭（religious obligations or as votive offerings.）。强调群体而不是个人的捐赠，一些贡献归于上帝的礼物。

对于约瑟夫斯来说，如果通过履行诫命来执行虔诚和服从上帝的行为，那么他们就可以接受。这包括向圣殿提供祭祀，献礼物，以及向有需要的人分发食物。**只有上帝才是真正的恩人**。此外，施瓦茨发现约瑟夫对于恩人的奖励不能采取物质形式。相反，<u>只有口头纪念被认为是合法的</u>，因为约瑟夫斯并没有完全拒绝，而是改编了希腊罗马的展示和互惠文化。

在Yoma 3中描绘的euergetism行为符合Schwartz在Josephus和Yerushalmi中发现的模式。首先，可接受的好处与==寺庙崇拜有关的诫命==的表现是一致的。其次，礼物回馈不是典型的希腊罗马礼物回馈，而是我们在其他犹太文本中看到的典型特征，因为恩人只是简单地记录而==没有任何可见或物质荣誉==。事实上，当拉比们传播这些传统时，这种记忆会以口头形式进一步延续。

第二篇关于国王Munbaz的饥荒救济，与早期的犹太人与euergetism的交集有一些相似之处，但也开辟了新的基础。首先，这种好处是典型的犹太情感可以接受的，它们允许提供支持有需要的人的礼物，但礼物是==无形的==（immaterial）。其次，Tannaim将叙述视为宗教奉献的行为（正义的慈善的行为）。Peah 4:18中没有提到“记忆”或“纪念”，而是从与正义和神圣正义的奖赏相关的大量拉比概念中提取的。在这一方面，Peah 18 更有创造性。它圣经和希腊化的犹太传统汇集在一起，用于公义和慈善的奖赏，并将它们与可接受的希腊罗马的euergetism形式混合在一起。蒙巴兹<u>不是纪念，而是追求世界上的经济回报</u>，这反映了他在这个世界上所做的物质贡献。他们的善行与他的好处完全相同，但在地点上却不同 - 这是一种典型的表现。通过消除物质奖励，Tosefta 从 euergetism 中消除了竞争。

Tannaim认为可接受的euergetism形式 - 对有需要的人的支持 - 与正义和救济的行为相结合，这些行为需要为捐助者提供超凡脱俗的奖励。



whzecomjm
2019年7月2日